#include "Relay_Timer.h"
//#include "RTClib.h"
struct MyDayTime currentDayTime;
char daysOfTheWeek[7][12] = { "Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday" };
//#define CLOCK_DEBUG

Clock_Class::Clock_Class(String str) { }

//***********************************************************************
//***********************************************************************
void Clock_Class::SendStatusToFirebase() {
#ifdef CLOCK_DEBUG
    Serial.println("Clock_Class::SendBattery_Status: ");
#endif
	String zeitUndDatum = SetClockToString();
    sendStringToFirebase(timeAndDatePath, zeitUndDatum); // Zeit und Datum an Firebase senden
    printText (0, 1, zeitUndDatum);

    if (rtc.lostPower()) sendIntToFirebase(statusPath + "batteryPower", 0);
    else sendIntToFirebase(statusPath + "batteryPower", 1);
    if (temp != GetTemp()) {
        temp = GetTemp();
        sendFloatToFirebase(tempPath, temp);
    }
    sendIntToFirebase(statusPath + "led", LED_Status);
    //temperature = bme.readTemperature(); // Temperaturwert lesen
    printText(0, 3, "Temp: " + String(GetTemp()));
}


//***********************************************************************
//***********************************************************************
void Clock_Class::SetCurrendDayTime(short year, short month, short day, short calendarDay, short hour, short min) {
#ifdef CLOCK_DEBUG
     Serial.println("Clock_Class::CurrendDayTime");
#endif
    currentDayTime.year = year;
    currentDayTime.month = month,
    currentDayTime.day = day;
    currentDayTime.calendarDay = calendarDay;
    currentDayTime.hour = hour;
    currentDayTime.minute = min;
 }

 //***********************************************************************
 //***********************************************************************
 void Clock_Class::PrintRTC(){
#ifdef CLOCK_DEBUG
    DateTime now = rtc.now();
    Serial.println("--------Clock_Class::PrintRTC-----------");
    Serial.print(now.year(), DEC);
    Serial.print('/');
    Serial.print(now.month(), DEC);
    Serial.print('/');
    Serial.print(now.day(), DEC);
    Serial.print(" (");
    Serial.print(now.dayOfTheWeek());
    Serial.print(") ");
    Serial.print(now.hour(), DEC);
    Serial.print(':');
    Serial.print(now.minute(), DEC);
    Serial.print(':');
    Serial.print(now.second(), DEC);
    Serial.println();
    Serial.print("Temperatur: ");
	Serial.print(rtc.getTemperature());
	Serial.println(" C");
    Serial.print("Lost power: ");
    if(rtc.lostPower()) Serial.println("YES\n");
    else Serial.println("NO\n");
#endif
  }

 //***********************************************************************
 //***********************************************************************
 void Clock_Class::CopyClocktoCurrent(){

#ifdef CLOCK_DEBUG
    Serial.println("Clock_Class::CopyClocktoCurrent  START");
#endif
    DateTime now = rtc.now();
    currentDayTime.year = now.year();
    currentDayTime.month = now.month(),
    currentDayTime.day = now.dayOfTheWeek();
    currentDayTime.calendarDay = now.day();
    currentDayTime.hour = now.hour();
    currentDayTime.minute = now.minute();
    currentDayTime.temp = rtc.getTemperature();
	PrintRTC(); 

 #ifdef CLOCK_DEBUG
    Serial.println("-----current.year="+ String(currentDayTime.year));
    Serial.println("-----current.month="+ String(currentDayTime.month));
    Serial.println("-----current.day="+ String(currentDayTime.day));
    Serial.println("-----current.calendar day="+ String(currentDayTime.calendarDay));
    Serial.println("-----current.hour="+ String(currentDayTime.hour));
    Serial.println("-----current.min="+ String(currentDayTime.minute));
    Serial.println("Clock_Class::CopyClocktoCurrent  END");
#endif
}

//***********************************************************************
//***********************************************************************
  String Clock_Class::SetClockToString(){
#ifdef CLOCK_DEBUG
      Serial.println("Clock_Class::SetClockToString");
#endif
      String str = "";
	  if (currentDayTime.calendarDay < 10) str = "0"+ String(currentDayTime.calendarDay)+".";
	  else str = String(currentDayTime.calendarDay) + ".";
      if(currentDayTime.month < 10) str += "0"+ String(currentDayTime.month)+".";
   	  else str += String(currentDayTime.month) + ".";
	  str += String(currentDayTime.year) + " ";
      if (currentDayTime.hour <10) str += "0" + String(currentDayTime.hour) + ":";
	  else str += String(currentDayTime.hour) + ":";
      if (currentDayTime.minute <10) str += "0" + String(currentDayTime.minute);
	  else str += String(currentDayTime.minute);
      

	  //str += String(currentDayTime.year) + "," + String(currentDayTime.month) + "," + String(currentDayTime.calendarDay) + "," + String(currentDayTime.hour) + ":" + String(currentDayTime.minute);
	  return str;   
  }
//***********************************************************************
//***********************************************************************
float Clock_Class::GetTemp(){
#ifdef CLOCK_DEBUG
      Serial.println("Clock_Class::GetTemp");
#endif
      return currentDayTime.temp;
  }
/**************************************************************************/

// @brief  RTC based on the DS3231 chip connected via I2C and the Wire library

/**************************************************************************/
/*class RTC_DS3231 : RTC_I2C {
public:
  bool begin(TwoWire *wireInstance = &Wire);
  void adjust(const DateTime &dt);
  bool lostPower(void);
  DateTime now();
  Ds3231SqwPinMode readSqwPinMode();
  void writeSqwPinMode(Ds3231SqwPinMode mode);
  bool setAlarm1(const DateTime &dt, Ds3231Alarm1Mode alarm_mode);
  bool setAlarm2(const DateTime &dt, Ds3231Alarm2Mode alarm_mode);
  DateTime getAlarm1();
  DateTime getAlarm2();
  Ds3231Alarm1Mode getAlarm1Mode();
  Ds3231Alarm2Mode getAlarm2Mode();
  void disableAlarm(uint8_t alarm_num);
  void clearAlarm(uint8_t alarm_num);
  bool alarmFired(uint8_t alarm_num);
  void enable32K(void);
  void disable32K(void);
  bool isEnabled32K(void);
  float getTemperature(); // in Celsius degree
  /*!
      @brief  Convert the day of the week to a representation suitable for
              storing in the DS3231: from 1 (Monday) to 7 (Sunday).
      @param  d Day of the week as represented by the library:
              from 0 (Sunday) to 6 (Saturday).
      @return the converted value
  
  static uint8_t dowToDS3231(uint8_t d) { return d == 0 ? 7 : d; }
};*/

