unsigned long dataMillis = 0;
unsigned int count = 1;
bool toggleUser = false;


//*****************************************************
//*****************************************************
void Checkfb_ready(){
	if (millis() - dataMillis > 5000)
	{
		dataMillis = millis();

		if (Firebase.ready())
		{
			//String path = "/UsersData/";
			databasePath += auth.token.uid.c_str(); //<- user uid of current user that sign in with Email/Password
			//path += "/test/int";
			Serial.printf("Checkfb_ready----Current UID: %s\n", auth.token.uid.c_str());
			Serial.printf("Checkfb_ready----Set int... %s\n", Firebase.RTDB.setInt(&fbdo, statusPath+"fbReady", count++) ? "ok" : fbdo.errorReason().c_str());
		}
	}
}



//*****************************************************
//*****************************************************
void Setup_Firebase() {
	// Firebase config
	config.api_key = API_KEY;
	auth.user.email = USER_EMAIL;
	auth.user.password = USER_PASSWORD;
	config.database_url = DATABASE_URL;
	Firebase.reconnectWiFi(true);
	fbdo.setResponseSize(4096);
	Serial.println("----------------CHECK 1");

	// Assign the callback function for the long-running token generation task	
	config.token_status_callback = tokenStatusCallback; // see addons/TokenHelper.h
	config.max_token_generation_retry = 5; // increase number of retries
	Firebase.begin(&config, &auth);
	Serial.println("----------------CHECK 2");
	while ((auth.token.uid) == "") {
#ifdef DEBUG
		Serial.print(".");
#endif
		delay(1000);
	}
	uid = auth.token.uid.c_str();
#ifdef DEBUG
	Serial.print("User UID: ");
	Serial.println(uid);
#endif
	//printText(0, 3, uid);
	Serial.println("----------------CHECK 3");
	databasePath = ("/UsersData/" + uid);
	listenerPath = (databasePath + "/outputs/");
	tempPath = (databasePath + "/inputs/temperature");
	timeAndDatePath = (databasePath + "/inputs/timeAndDate");
	statusPath = (databasePath + "/inputs/status/");
	timerPath = (databasePath + "/outputs/timer/");
#ifdef DEBUG
	Serial.println("listener path: " + listenerPath);
#endif
	if (!Firebase.RTDB.beginStream(&stream, listenerPath.c_str()))
	{
#ifdef DEBUG
		Serial.printf("stream begin error, %s\n\n", stream.errorReason().c_str());
#endif
	}
	Firebase.RTDB.setStreamCallback(&stream, streamCallback, streamTimeoutCallback);

}



//*****************************************************
//*****************************************************
void sendStringToFirebase(String path, String value) {
	if (Firebase.RTDB.setString(&fbdo, path.c_str(), value.c_str())) {
# ifdef DEBUG
		Serial.printf("Set string data successful, path: %s, value: %s\n", path.c_str(), value.c_str());
#endif
	}
	else {
#ifdef DEBUG
		Serial.printf("Failed to set string data, path: %s, value: %s\n", path.c_str(), value.c_str());
		Serial.printf("REASON: %s\n", fbdo.errorReason().c_str());
#endif
	}
}

//*****************************************************
void sendFloatToFirebase(String path, float value) {
	if (Firebase.RTDB.setFloat(&fbdo, path.c_str(), value)) {
#ifdef DEBUG
		Serial.printf("Set float data successful, path: %s, value: %f\n", path.c_str(), value);
#endif
	}
	else {
#ifdef DEBUG
		Serial.printf("Failed to set float data, path: %s, value: %f\n", path.c_str(), value);
		Serial.printf("REASON: %s\n", fbdo.errorReason().c_str());
#endif
	}
}

//*****************************************************
void sendIntToFirebase(String path, int value) {
	if (Firebase.RTDB.setInt(&fbdo, path.c_str(), value)) {
#ifdef DEBUG
		Serial.printf("Set int data successful, path: %s, value: %d\n", path.c_str(), value);
#endif
	}
	else {
#ifdef DEBUG
		Serial.printf("Failed to set int data, path: %s, value: %d\n", path.c_str(), value);
		Serial.printf("REASON: %s\n", fbdo.errorReason().c_str());
#endif
	}
}

//*****************************************************
// // Callback runs on Firebase changes
//*****************************************************
void streamCallback(FirebaseStream data) {
#ifdef DEBUG
	Serial.printf("stream path: %s\n", data.streamPath().c_str());
	Serial.printf("data path: %s\n", data.dataPath().c_str());
	Serial.printf("data type: %s\n", data.dataType().c_str());
	Serial.printf("event type: %s\n", data.eventType().c_str());
	printResult(data);
	Serial.println();
#endif
	String streamPath = String(data.dataPath());
	String deviceText = "";

	// Read complete JSON object at beginning
	if (data.dataTypeEnum() == fb_esp_rtdb_data_type_json) {
		FirebaseJson* json = data.to<FirebaseJson*>();
		FirebaseJsonData result;
		int state = 0;
		String text = "Unused";
		if (json->get(result, "/digital/led", false)) {
			state = result.to<int>();
			int out = (state == 0) ? HIGH : LOW;
			digitalWrite(LED1, out);
			deviceText = "LED";
			Serial.println("Firebase change LED" + String(state));
		}
		if (json->get(result, "/digital/relay1", false)) {
			state = result.to<int>();
			deviceText = "RELAY_1";
			int out = (state == 0) ? HIGH : LOW;
			digitalWrite(RELAY_1, out);
			Serial.println("RELAIS_1" + String(state));
		}
		if (json->get(result, "/digital/relay2", false)) {
			state = result.to<int>();
			int out = (state == 0) ? HIGH : LOW;
			digitalWrite(RELAY_2, out);
			deviceText = "RELAY_2";
			//Serial.println("RELAIS_2" + String(state));
		}
		if (json->get(result, "/digital/relay3", false)) {
			state = result.to<int>();
			int out = (state == 0) ? HIGH : LOW;
			digitalWrite(RELAY_3, out);
			deviceText = "RELAY_3";
			//Serial.println("RELAIS_3" + String(state));
		}
		if (json->get(result, "/digital/relay4", false)) {
			state = result.to<int>();
			int out = (state == 0) ? HIGH : LOW;
			digitalWrite(RELAY_4, out);
			deviceText = "RELAY_4";
			//Serial.println("RELAIS_4" + String(state));
		}
		if (json->get(result, "/message", false)) {
			text = result.to<String>();
			deviceText = "Message: ";
			//Serial.printf("message: %s\n", text);
			printText(0, 3, text);
		}
		if (json->get(result, "/timer/timer1", false)) {
			text = result.to<String>();
			deviceText = "TIMER_1: ";
			Serial.printf("Timer1: %s\n", text);
			Relay_Timer.StoreAndSetTimer(text, 0);
		}
		if (json->get(result, "/timer/timer2", false)) {
			text = result.to<String>();
			deviceText = "TIMER_2: ";
			//Serial.printf("timer2: %s\n", text);
			Relay_Timer.StoreAndSetTimer(text, 1);
		}
		if (json->get(result, "/timer/timer3", false)) {
			text = result.to<String>();
			deviceText = "TIMER_3: ";
			//Serial.printf("timer3: %s\n", text);
			Relay_Timer.StoreAndSetTimer(text, 2);
		}
		if (json->get(result, "/timer/timer4", false)) {
			text = result.to<String>();
			deviceText = "TIMER_4: ";
			//Serial.printf("timer4: %s\n", text);
			Relay_Timer.StoreAndSetTimer(text, 3);
		}
#ifdef DEBUG
		Serial.println(deviceText + " ---> " + String(state));
		Serial.println(deviceText + " ---> " + text);
		for (int i = 0; i < 4; i++) {
			Serial.printf("Relay_Timer %d: %s\n", i + 1, Relay_Timer.Timers[i]);
		}
#endif
	}
	// Read individual changes
	if (streamPath.indexOf("/digital/") >= 0) {
		int stingLength = streamPath.length();
		int lastSlash = streamPath.lastIndexOf("/");
		String relayName = streamPath.substring(lastSlash + 1, stingLength);
		int state = data.intData();
#ifdef DEBUG
		Serial.println("Relay Name: " + relayName);
		Serial.println("State: " + String(state));
#endif
		if (relayName == "led") {
			int out = (state == 0) ? HIGH : LOW;
			digitalWrite(LED1, out);
			LED_Status = out;
		}
		else if (relayName == "relay1") {
			int out = (state == 0) ? HIGH : LOW;
			digitalWrite(RELAY_1, out);
		}
		else if (relayName == "relay2") {
			int out = (state == 0) ? HIGH : LOW;
			digitalWrite(RELAY_2, out);
		}
		else if (relayName == "relay3") {
			int out = (state == 0) ? HIGH : LOW;
			digitalWrite(RELAY_3, out);
		}
		else if (relayName == "relay4") {
			int out = (state == 0) ? HIGH : LOW;
			digitalWrite(RELAY_4, out);
		}
	}
	else if (streamPath == "/message") {
		String text = data.stringData();
#ifdef DEBUG
		Serial.printf("data string: %s\n", data.stringData().c_str());
#endif
		printText(0, 3, text);
	}
	if (streamPath.indexOf("/timer/") >= 0) {
		int stingLength = streamPath.length();
		int lastSlash = streamPath.lastIndexOf("/");
		String timerName = streamPath.substring(lastSlash + 1, stingLength);
		String timerValue = data.stringData();
#ifdef DEBUG
		Serial.println("Timer Name: " + timerName);
		Serial.println("State: " + timerValue);
#endif
		if (timerName == "timer1") {
			Relay_Timer.StoreAndSetTimer(timerValue, 0);
			Serial.println("###############Timer1 read and timer1Resp set to 1");
			sendIntToFirebase(statusPath + "timer1resp", 1);
		}
		else if (timerName == "timer2") {
			Relay_Timer.StoreAndSetTimer(timerValue, 1);
			sendIntToFirebase(statusPath + "timer2resp", 1);
		}
		else if (timerName == "timer3") {
			Relay_Timer.StoreAndSetTimer(timerValue, 2);
			sendIntToFirebase(statusPath + "timer3resp", 1);
		}
		else if (timerName == "timer4") {
			Relay_Timer.StoreAndSetTimer(timerValue, 3);
			sendIntToFirebase(statusPath + "timer4resp", 1);
		}
#ifdef DEBUG
		for (int i = 0; i < 4; i++) {
			Serial.println("Firebase Timer String ---------->   " + Relay_Timer.Timers[i]);
		}
#endif
	}
}

//*****************************************************
//*****************************************************
void streamTimeoutCallback(bool timeout) {
	if (timeout) {
#ifdef DEBUG
		Serial.println();
		Serial.printf("!!!!!!!!!!!!!!!!!!Stream timeout, resuming...\n");
#endif
	}
	if (!stream.httpConnected()) {
#ifdef DEBUG
		Serial.printf("!!!!!!!!!!!!!!!!!!!!!!Stream disconnected, resuming...\n");
		Serial.printf("!!!!!!!!!!!!!!!!!!!!!!error code: %d, reason: %s\n\n", stream.httpCode(), stream.errorReason().c_str());
#endif
	}
}

