#include "time.h"
#include "esp_sntp.h"

//#define NTP_DEBUG

const char* ntpServer1 = "pool.ntp.org";
const char* ntpServer2 = "time.nist.gov";
const long gmtOffset_sec = 3600;
const int daylightOffset_sec = 3600;
const char* time_zone = "CET-1CEST,M3.5.0,M10.5.0/3";  // TimeZone rule for Europe/Rome including daylight adjustment rules (optional)

//******************************************
//Print local time**************************
bool GetLocalTimeNTP() {
#ifdef NTP_DEBUG
    Serial.println("GetLocalTimeNTP");
#endif
    struct tm timeinfo;
	if (!getLocalTime(&timeinfo)) {  // Try to get NTP time
#ifdef NTP_DEBUG
        Serial.println("No time available (yet)");
#endif
        return false;
    }
#ifdef NTP_DEBUG
    Serial.println(&timeinfo, "TimeInfo   %A, %B %d %Y %H:%M:%S");
#endif
    
	DateTime dt = DateTime(     // Convert struct tm to DateTime
        timeinfo.tm_year + 1900,
        timeinfo.tm_mon + 1,
        timeinfo.tm_mday,
        timeinfo.tm_hour,
        timeinfo.tm_min,
        timeinfo.tm_sec
    );

	rtc.adjust(dt);  // Set RTC from NTP time

    
    Clock.CopyClocktoCurrent();
                /*struct tm
                { 
                    int	tm_sec;
                    int	tm_min;
                    int	tm_hour;
                    int	tm_mday;
                    int	tm_mon; 
                    int	tm_year;
                    int	tm_wday;
                    int	tm_yday;
                    int	tm_isdst;
            #ifdef __TM_GMTOFF
                    long	__TM_GMTOFF;
            #endif
            #ifdef __TM_ZONE
                    const char* __TM_ZONE;
            #endif
                };*/    
	return true;
}

//*********************************************************
// Callback function (gets called when time adjusts via NTP)
void Timeavailable(struct timeval* t) {
#ifdef NTP_DEBUG
    Serial.println("timeavailable ->Got time adjustment from NTP!");
#endif
    GetLocalTimeNTP();
}

//***********************************************************
//***********************************************************
void SetNTP() {
#ifdef NTP_DEBUG
    Serial.println("SetNTP");
#endif
    // set notification call-back function
    //sntp_set_time_sync_notification_cb(Timeavailable);

    /**
     * This will set configured ntp servers and constant TimeZone/daylightOffset
     * should be OK if your time zone does not need to adjust daylightOffset twice a year,
     * in such a case time adjustment won't be handled automagically.
     */
	configTime(gmtOffset_sec, daylightOffset_sec, ntpServer1, ntpServer2); // Set NTP configuration

    /**
     * A more convenient approach to handle TimeZones with daylightOffset
     * would be to specify a environment variable with TimeZone definition including daylight adjustmnet rules.
     * A list of rules for your zone could be obtained from https://github.com/esp8266/Arduino/blob/master/cores/esp8266/TZ.h
     */
	configTzTime(time_zone, ntpServer1, ntpServer2);  // Set NTP configuration with time zone and daylight adjustment rules
     
}

