// Relay_Timer.h

#ifndef _RELAY_TIMER_h
#define _RELAY_TIMER_h

constexpr auto NumOfTimers = 4;




struct MyTimerEvents
{
    short day;       // Unused=7, Mon=1, Tue=2, Wed=3, Thu=4, Fri=5, Sat=6, Sun=0, Mon-Sun=9
    short onTimeH;
    short onTimeM;
    short offTimeH;
    short offTimeM;
    short repeat;    // 0=off, 1=on
    short program;   // Relay 1-4
    short active;    // 0=Realy off, 1= Relay on 
};
struct MyDayTime
{

    short year;         // tm_year since 1900 means +1900
    short month;        // tm_mon   
    short day;          // tm_wday
    short calendarDay;  // calendar day
    short hour;         // tm_hour
    short minute;       // tm_min
    float temp;
};


enum  MyDaysOfWeek// Entspr. tm_w
{
    Sun = 0,
    Mon,
    Tue, 
    Wed,
    Thu,
    Fri,
    Sat,
    Unused,
    nix,
    Mon_Sun
};

//***********************************************************************
//***********************************************************************

class Relay_TimerClass
{
protected:


public:
Relay_TimerClass(String str);

struct MyTimerEvents te[NumOfTimers];
String Timers[NumOfTimers];
struct MyDayTime currentDayTime;

void CheckTimer();

void Splitter( int tim);

void EEPROM_Begin();
void Read_EEPROM();
String Read_EEPROM_One_timer(int timer);
void Write_EEPROM();
void Write_EEPROM_One_timer(int timer);
void StoreAndSetTimer(String text, int i);
void DeleteTimer(int i);
};

//***********************************************************************
//***********************************************************************
class Clock_Class
{
protected:


public:  
struct MyDayTime currentDayTime;
float temp = 0;//struct DayTime  Day_Time; 
//int DT;
Clock_Class(String str);
void SendStatusToFirebase();
void SetCurrendDayTime(short year, short month, short day, short calendarDay, short hour, short min); //????
void PrintRTC();
void CopyClocktoCurrent();
String SetClockToString();
float GetTemp();
};
//extern Relay_TimerClass Relay_Timer;

#endif

