// 
// 
// 
//#include <Arduino.h>
#include "Relay_Timer.h"
#include <semaphore.h>
//#define RELAY_DEBUG
//#define RELAY_DEBUG1

//String Timers[NumOfTimers] = { "Tue;08:30;19:30;1;1", "Fri;08:30;19:30;0;2", "Mon-Sun;08:30;09:30;0;3", "Wed;08:30;09:30;0;4" };

int Relays[NumOfTimers]  = { 17,18,4,5 };

EEPROMClass TIMER0("eeprom0");
EEPROMClass TIMER1("eeprom1");
EEPROMClass TIMER2("eeprom2");
EEPROMClass TIMER3("eeprom3");

//struct DayTime currentDayTime;

//***********************************************************************
// Konstruktor
//***********************************************************************

Relay_TimerClass::Relay_TimerClass(String str) {
    //Serial.println("Relay Timer Class Created   " + str);
    //EEPROM_Begin();
     //Read_EEPROM();
    //Conctructor = 1;

}
//***********************************************************************
//***********************************************************************
void Relay_TimerClass::DeleteTimer(int tim) {
#ifdef RELAY_DEBUG
    Serial.println("Relay_TimerClass::DeleteTimer: " + String(tim));
#endif
    String tm;
    if (tim == 0) tm = "timer1";
    else if (tim == 1) tm = "timer2";
    else if (tim == 2) tm = "timer3";
    else if (tim == 3) tm = "timer4";
    sendStringToFirebase(timerPath + tm, "Unused"); // Delete timer in Firebase
	Timers[tim] = "Unused";
	te[tim].day = Unused;
}
//***********************************************************************
//***********************************************************************
    void Relay_TimerClass::StoreAndSetTimer(String text, int tim) {
#ifdef RELAY_DEBUG
    Serial.println("Relay_TimerClass::StoreAndSetTimer: " + text);
#endif
    Timers[tim] = text;
    Write_EEPROM_One_timer(tim);
    if (text != "Unused") Splitter(tim);
    else
    {
        Timers[tim] = "Unused";
        te[tim].day = Unused;
    }
#ifdef RELAY_DEBUG
    Serial.println("Relay_TimerClass::StoreAndSetTimer-Timers[" + String(tim) + "]: "  + Relay_Timer.Timers[tim]);
#endif
    }

//***********************************************************************
//***********************************************************************
    void Relay_TimerClass::Splitter(/*TimerEvents *te, String str1,*/ int tim)
    {
#ifdef RELAY_DEBUG
    Serial.println("Relay_TimerClass::Splitter");
#endif
    //timerEvents te = new timerEvents();
    //if (te[tim].day == Unused || Timers[tim] == "Unused") return; // Split timer string only if not "Unused"

    String str1= Timers[tim];
    int s1 = str1.indexOf(";");
    int s2 = str1.indexOf(";", s1 + 1);
	int s3 = str1.indexOf(";", s2 + 1);
	int s4 = str1.indexOf(";", s3 + 1);
	String day = str1.substring(0, s1);
	String t_on = str1.substring(s1 + 1, s2); 
	String t_off = str1.substring(s2 + 1, s3);
	String rep = str1.substring(s3 + 1, s4);
	String relay = str1.substring(s4 + 1);
    //TimerEvents te = te_all[timer_num];

    if (day == "Mon-Sun")
    {
        te[tim].day = Mon_Sun;
    }
    else if (day =="Mon")
    {
       te[tim].day = Mon;
    }
    else if (day =="Tue")
    {
        te[tim].day = Tue;
    }
    else if (day =="Wed")
    {
        te[tim].day = Wed;
    }
    else if (day =="Thu")
    {
        te[tim].day = Thu;
    }
    else if (day =="Fri")
    {
        te[tim].day = Fri;
    }
    else if (day =="Sat")
    {
        te[tim].day = Sat;
    }
    else if (day =="Sun")
    {
        te[tim].day = Sun;
    }
    else
    {
        te[tim].day = Unused;
    }
   //Serial.println("Day: " + String(day) + "------------");
 
    s1 = t_on.indexOf(":");
    String on_t_h = t_on.substring(0, s1);
    if ( on_t_h.substring(0,1) == "0") {on_t_h = on_t_h.substring(1,s1);} // Delete leading 0
    String on_t_m = t_on.substring(s1 + 1);
    if ( on_t_m.substring(s1+1,s1+2) == "0") {on_t_m = on_t_m.substring(s1+2);} // Delete leading 0
    s2 = t_off.indexOf(":");
    String off_t_h = t_off.substring(0, s2);
     if ( off_t_h.substring(0,1) == "0") {off_t_h = off_t_h.substring(1,s2);} // Delete leading 0
    String off_t_m = t_off.substring(s2 + 1);
    if ( off_t_m.substring(s2+1,s2+2) == "0") {off_t_m = off_t_m.substring(s2+2);} // Delete leading 0

    te[tim].onTimeH = on_t_h.toInt();
    te[tim].onTimeM = on_t_m.toInt();
    te[tim].offTimeH = off_t_h.toInt();
    te[tim].offTimeM = off_t_m.toInt();
    te[tim].repeat = rep.toInt();
    te[tim].program = relay.toInt();
    //MessageBox.Show("Days: " + day + "\nTime From: " + timeFrom + "\nTime To: " + timeTo + "\nRepeat: " + repeat + "\nProgram: " + program);
    //Serial.println("Day: " + String(day) + "\nTime From: " + t_on + "\nTime To: " + t_off + "\nRepeat: " + rep + "\nProgram: " + relay + "\n------------");
    //return (te);
#ifdef RELAY_DEBUG1
    Serial.println("te[tim].>day="+String(te[tim].day)+ "-----");
    Serial.println("te[tim].onTimeH="+String(te[tim].onTimeH)+ "-----");
    Serial.println("te[tim].onTimeM="+String(te[tim].onTimeM)+ "-----");
    Serial.println("te[tim].offTimeH="+String(te[tim].offTimeH)+ "-----");
    Serial.println("te[tim].offTimeM="+String(te[tim].offTimeM)+ "-----");
#endif
    }
//***********************************************************************
//***********************************************************************
void Relay_TimerClass::CheckTimer()
{
#ifdef RELAY_DEBUG
    Serial.println("Relay_TimerClass::CheckTimer");
#endif
    for (size_t tim = 0; tim < NumOfTimers; tim++) // check all timers
    {
#ifdef RELAY_DEBUG1
        Serial.println("Timer String: " + String(tim+1) + " ---------->   " + Timers[tim]);
        Serial.println("te->day="+String(te[tim].day)+ "-----currentday="+ String(Clock.currentDayTime.day));
        Serial.println("te->onTimeH="+String(te[tim].onTimeH)+ "-----current.hour="+ String(Clock.currentDayTime.hour));
        Serial.println("te->onTimeM="+String(te[tim].onTimeM)+ "-----current.min="+ String(Clock.currentDayTime.minute));
        Serial.println("te->offTimeH="+String(te[tim].offTimeH)+ "-----current.hour="+ String(Clock.currentDayTime.hour));
        Serial.println("te->offTimeM="+String(te[tim].offTimeM)+ "-----current.min="+ String(Clock.currentDayTime.minute));
#endif	
        if (Timers[tim] == "Unused")
        {
            digitalWrite(Relays[tim], HIGH);
            continue; // Check timer string only if not "Unused"
        }
        if ( te[tim].day == Clock.currentDayTime.day || te[tim].day == (short)Mon_Sun)
        {
            if (te[tim].active == 0 && (te[tim].onTimeH == Clock.currentDayTime.hour && te[tim].onTimeM <= Clock.currentDayTime.minute))
            {
#ifdef RELAY_DEBUG1
                Serial.println("Timer-" + String(tim) + " active Relais= " + String(te[tim].program));
#endif
                te[tim].active = 1;
            }

            if (te[tim].active == 1 && (te[tim].offTimeH  == Clock.currentDayTime.hour && te[tim].offTimeM <= Clock.currentDayTime.minute))
            {
                te[tim].active = 0;
#ifdef RELAY_DEBUG1
                Serial.println("Timer-" + String(tim) + " inactive Relais= " + String(te[tim].program));
#endif
                if (te[tim].repeat == 0 && te[tim].day != (short)Mon_Sun)
                {
				    DeleteTimer(tim);
                    //te[tim].day = (short)Unused; // Disable the timer after it has been executed
#ifdef RELAY_DEBUG
                    Serial.println("Stopp - Timer " + String(tim));
#endif
                }
            }
        }
        int out = (te[tim].active == 0) ? HIGH : LOW;
        digitalWrite(Relays[tim], out);
        
    }
}

//***********************************************************************
//***********************************************************************
void Relay_TimerClass::EEPROM_Begin(){
#ifdef RELAY_DEBUG
    Serial.println("Relay_TimerClass::EEPROM_Begin");
#endif
    if (!TIMER0.begin(50)) {
#ifdef RELAY_DEBUG
            Serial.println("Failed to initialize EEPROM-TIMER0");
            Serial.println("Restarting...");
#endif
            delay(1000);
            ESP.restart();	
    }
    if (!TIMER1.begin(50)) {
#ifdef RELAY_DEBUG

            Serial.println("Failed to initialize EEPROM_TIMER1");
            Serial.println("Restarting...");
#endif
            delay(1000);
            ESP.restart();	
    }
    if (!TIMER2.begin(50)) {
#ifdef RELAY_DEBUG

            Serial.println("Failed to initialize EEPROM_TIMER2");
            Serial.println("Restarting...");
#endif
            delay(1000);
            ESP.restart();	
    }
    if (!TIMER3.begin(50)) {
#ifdef RELAY_DEBUG

            Serial.println("Failed to initialize EEPROM_TIMER3");
            Serial.println("Restarting...");
#endif
            delay(1000);
            ESP.restart();	
    }
}


//***********************************************************************
//***********************************************************************
void Relay_TimerClass::Read_EEPROM(){
#ifdef RELAY_DEBUG
    Serial.println("Relay_TimerClass::Read_EEPROM  START");
#endif
    xSemaphoreTake(EEPROM_Mutex, portMAX_DELAY);
    Timers[0] = TIMER0.readString(0);
#ifdef RELAY_DEBUG
    Serial.println("Read_EEPROM Timer 0" + Timers[0]);
#endif
	Timers[1] = TIMER1.readString(0);
#ifdef RELAY_DEBUG
    Serial.println("Read_EEPROM Timer 1" + Timers[1]);
#endif  
	Timers[2] = TIMER2.readString(0);
#ifdef RELAY_DEBUG
    Serial.println("Read_EEPROM Timer 2" + Timers[2]);
#endif
	Timers[3] = TIMER3.readString(0);
#ifdef RELAY_DEBUG
    Serial.println("Read_EEPROM Timer 3" + Timers[3]);
#endif
    xSemaphoreGive(EEPROM_Mutex);
#ifdef RELAY_DEBUG
    Serial.println("Relay_TimerClass::Read_EEPROM  END");
#endif

}
String Relay_TimerClass::Read_EEPROM_One_timer(int timer){
#ifdef RELAY_DEBUG
    Serial.println("Relay_TimerClass::Read_EEPROM_One_timer");
#endif
    xSemaphoreTake(EEPROM_Mutex, portMAX_DELAY);
    if(timer == 0){Timers[0]=TIMER0.readString(0);return Timers[0];}
	else if(timer == 1){Timers[1]=TIMER1.readString(0);return Timers[1];}
	else if(timer == 2){Timers[2]=TIMER2.readString(0);return Timers[2];}
	else if(timer == 3){Timers[3]=TIMER3.readString(0);return Timers[3];}
    xSemaphoreGive(EEPROM_Mutex);

}

//***********************************************************************
// Writes all 4 timer values to flash
//***********************************************************************
void Relay_TimerClass::Write_EEPROM(){
#ifdef RELAY_DEBUG
    Serial.println("Relay_TimerClass::Write_EEPROM");
#endif
    xSemaphoreTake(EEPROM_Mutex, portMAX_DELAY);
    TIMER0.writeString(0,Timers[0]);
	TIMER1.writeString(0,Timers[1]);
	TIMER2.writeString(0,Timers[2]);
	TIMER3.writeString(0,Timers[3]);
	TIMER0.commit();
	TIMER1.commit();
	TIMER2.commit();
	TIMER3.commit();
	xSemaphoreGive(EEPROM_Mutex);
}

//***********************************************************************
//***********************************************************************
void Relay_TimerClass::Write_EEPROM_One_timer(int timer){ // Timer Address from 0 - 3
#ifdef RELAY_DEBUG
    Serial.println("Relay_TimerClass::Write_EEPROM_One_timer");
#endif
    xSemaphoreTake(EEPROM_Mutex, portMAX_DELAY);
    if(timer == 0){TIMER0.writeString(0,Timers[0]);TIMER0.commit();}
	else if(timer == 1){TIMER1.writeString(0,Timers[1]);TIMER1.commit();}
	else if(timer == 2){TIMER2.writeString(0,Timers[2]);TIMER2.commit();}
	else if(timer == 3){TIMER3.writeString(0,Timers[3]);TIMER3.commit();}
    xSemaphoreGive(EEPROM_Mutex);
}




