/*
 Name:		Slitter_Test.ino
 Created:	13.12.2025 14:17:45
 Author:	Roland
*/

#include <Arduino.h>
#include "Relay_Timer.h"
#include"EEPROM.h"
#include "RTClib.h"
#include <Wire.h>
#include <LiquidCrystal_I2C.h>

#define SDA 15                    //Define SDA pins
#define SCL 16                    //Define SCL pins
LiquidCrystal_I2C lcd(0x27,20,4); 

//String Timers[NumOfTimers] = { "Di;08:30;19:30;1;1", "Fr;08:30;19:30;0;2", "Mo-So;08:30;09:30;0;3", "Mi;08:30;09:30;0;4" };
//int Conctructor =0;
//Instanziere Klasse
Relay_TimerClass Relay_Timer("Start");
Clock_Class Clock("Start");
RTC_DS3231 rtc;

char daysOfTheWeek[7][12] = {"Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"};


// InitClock ************************************
void InitTimerAndCheck() {
	Serial.println("---- Init Timer and Splitter ----");	
	for (int i = 0; i < NumOfTimers; i++) {
		// Set pregiven timer
	//	Relay_Timer.Splitter(&Relay_Timer.te[i], Relay_Timer.Timers[i], i);
		Relay_Timer.Splitter(i);
		//Relay_Timer.te[i].active = 0;
		//Serial.println("---- te.active = 0 ----");	
}

	
	Serial.println("---- Timer Check Start ----");
	for (int i = 0; i < 8; i++)
	{
		switch (i)
		{
		case 0:
			Clock.CurrendDayTime(2025, 12, Di, 19, 8, 30);
			//Relay_Timer.currentDayTime.day = Di;
			//Relay_Timer.currentDayTime.hour = 8;
			//Relay_Timer.currentDayTime.minute = 30;
			Serial.println("Switch 0");
			break;
		case 1:
			Clock.CurrendDayTime(2025, 12, Di, 19, 9, 30);
			/*Relay_Timer.currentDayTime.day = Di;
			Relay_Timer.currentDayTime.hour = 9;
			Relay_Timer.currentDayTime.minute = 30;*/
			Serial.println("Switch 1");
			break;
		case 2:
			Clock.CurrendDayTime(2025, 12, Di, 19, 19, 30);
			/*Relay_Timer.currentDayTime.day = Di;
			Relay_Timer.currentDayTime.hour = 19;
			Relay_Timer.currentDayTime.minute = 30;*/
			Serial.println("Switch 2");
			break;
		case 3:
			Clock.CurrendDayTime(2025, 12, Mi, 19, 8, 30);
			/*Relay_Timer.currentDayTime.day = Mi;
			Relay_Timer.currentDayTime.hour = 8;
			Relay_Timer.currentDayTime.minute = 30;*/
			Serial.println("Switch 3");
			break;
		case 4:
			Clock.CurrendDayTime(2025, 12, Mi, 19, 9, 30);
			/*Relay_Timer.currentDayTime.day = Mi;
			Relay_Timer.currentDayTime.hour = 9;
			Relay_Timer.currentDayTime.minute = 30;*/
			Serial.println("Switch 4");
			break;
		case 5:
			Clock.CurrendDayTime(2025, 12, Fr, 19, 8, 30);
			/*Relay_Timer.currentDayTime.day = Fr;
			Relay_Timer.currentDayTime.hour = 8;
			Relay_Timer.currentDayTime.minute = 30;*/
			Serial.println("Switch 5");
			break;
		case 6:
			Clock.CurrendDayTime(2025, 12, Fr, 19, 9, 30);
			/*Relay_Timer.currentDayTime.day = Fr;
			Relay_Timer.currentDayTime.hour = 9;
			Relay_Timer.currentDayTime.minute = 30;*/
			Serial.println("Switch 6");
			break;
		case 7:
			Clock.CurrendDayTime(2025, 12, Fr, 19, 19, 30);
			//Relay_Timer.currentDayTime.day = Fr;
			//Relay_Timer.currentDayTime.hour = 19;
			//Relay_Timer.currentDayTime.minute = 30;
			//Serial.println("Switch 7");
			break;
		}
		//Serial.printf("Current Day: %d  Time: %02d:%02d\n", Relay_Timer.currentDayTime.day, Relay_Timer.currentDayTime.hour, Relay_Timer.currentDayTime.minute);
		for (int j = 0; j < NumOfTimers; j++) // check all timers
		{
		Serial.println("!Relay_Timer.day="+String(Relay_Timer.te[j].day)+ "-----currentday="+ String(Clock.currentDayTime.day));
    Serial.println("!Relay_Timer.onTimeH="+String(Relay_Timer.te[j].onTimeH)+ "-----current.hour="+ String(Clock.currentDayTime.hour));
    Serial.println("!Relay_Timer.onTimeM="+String(Relay_Timer.te[j].onTimeM)+ "-----current.min="+ String(Clock.currentDayTime.minute));
    Serial.println("!Relay_Timer.offTimeH="+String(Relay_Timer.te[j].offTimeH)+ "-----current.hour="+ String(Clock.currentDayTime.hour));
    Serial.println("!Relay_Timer.offTimeM="+String(Relay_Timer.te[j].offTimeM)+ "-----current.min="+ String(Clock.currentDayTime.minute));
//Serial.println("size of(Relay_Timer.te): "+ String(sizeof(Relay_Timer.te)));
			//Relay_Timer.CheckTimer(&Relay_Timer.te[j], Clock.currentDayTime);
			Relay_Timer.CheckTimer(j, Clock.currentDayTime);
			//MessageBox.Show("Outer/InnerLoop: "+ i+ "/" +j + "Relay-Status von : " 
			//    + Convert.ToString(te[j].program) + " = " +Convert.ToString(te[j].active));
		}

		for (int k = 0; k < NumOfTimers; k++) // show all relay status
		{
			Serial.println("Timer: " + String(k) + "    Relay:  " + String(Relay_Timer.te[k].program) + "=" + String(Relay_Timer.te[k].active));
		} 
	}
}
void lcdInit (){
  lcd.init();                     // LCD driver initialization
  lcd.backlight();                // Turn on the backlight
  lcd.setCursor(0, 0);// set the cursor to column 0, line 0
  lcd.print("   Home Assistant");
  //callMitObj(lcd);
}

void printText(int col, int row, String text)
{
  lcd.setCursor(col, row);// set the cursor to column and row
  lcd.print(text);
}


// the setup function runs once when you press reset or power the board

void setup() {
	//Relay_TimerClass Relay_Timer();
  Serial.begin(115200);
  Wire.begin(SDA, SCL);           // attach the IIC pin
	
	lcdInit();
	printText(0, 1, "String text");
	if(!rtc.begin()){
    Serial.println("Failed to initialize RTC 3231");
    Serial.println("Restarting...");
    delay(1000);
    ESP.restart();	
	}
	//rtc.adjust(DateTime(2025,12,18,17,53,00)); //year, month, day, hour, min, sec

  //Relay_Timer.Write_EEPROM();	// Zum Testen
	//Serial.println("Konstuktor = " + String(Conctructor));
	for(int i=0; i<NumOfTimers; i++){
		Relay_Timer.Timers[i] = "leer";
		}
  Relay_Timer.EEPROM_Begin();
	Relay_Timer.Read_EEPROM();
	/*for(int i=0; i<NumOfTimers; i++){
		Serial.println(" Timer from Flash " + String(i) + "= " + Timers[i]);
	}*/
		InitTimerAndCheck();

	
		Clock.CpyClock();

}

// the loop function runs over and over again until power down or reset
void loop() {
		Clock.PrintRTC();
    delay(3000);
} 
