//#include <Arduino.h>
#define TIMER_DEBUG

TimerHandle_t Timer10Sec = NULL;

void TimerCallback(TimerHandle_t xTimer) {
#ifdef TIMER_DEBUG
    //Serial.println("Timer interrupt all 10sec: "+ String(timeout));
#endif
    timeout_minute++;
	wakeUpCount++;
	if (wakeUpCount >= 12) ESP.restart(); // Restart every 12 wake ups (2 min)
}

void intTimer() {
    Timer10Sec = xTimerCreate(
        "BlinkTimer",                   // Timer name
        10000 / portTICK_PERIOD_MS,      // 10s period
        pdTRUE,                         // Auto-reload (periodic timer)
        NULL,                           // Timer ID
        TimerCallback                   // Callback function
    );
	if (Timer10Sec != NULL) {
        xTimerStart(Timer10Sec, 0); // Start the timer
#ifdef TIMER_DEBUG
        Serial.println("Timer interrupt initialisiert und gestartet");
#endif
		timeout_minute = 0;                // Initialize minute counter
    }else
        {
#ifdef TIMER_DEBUG
        Serial.println("Fehler beim Erstellen des Timers");
#endif
	}
}
