/*
 Name:		X4_Relay_Firebase.ino
 Created:	15.11.2025 17:03:51
 Author:	Roland Gaidzik
*/

// the setup function runs once when you press reset or power the board

#include <BluetoothSerial.h>
#include <BTAddress.h>
#include <BTAdvertisedDevice.h>
#include <BTScan.h>
#include "RTClib.h"
#include "EEPROM.h"

#include "Relay_Timer.h"
#define DEBUG 

//#include <splash.h>
#include <WiFi.h> 
#include <Firebase_ESP_Client.h>
#include <LiquidCrystal_I2C.h>
#include <Wire.h>
#include <Adafruit_BME280.h>
//#include <Adafruit_GFX.h>
#include <Adafruit_Sensor.h>
//#include <Adafruit_SSD1306.h>

#include <addons/TokenHelper.h>
#include <addons/RTDBHelper.h>	
#include "Relay_Timer.h"

#define SDA 15
#define SCL 16

#define  RELAY_1 17
#define  RELAY_2 18
#define  RELAY_3 4
#define  RELAY_4 5

#define  LED1 6
#define  LED2 7

#define  WIFI_SSID "SSID1"
#define  WIFI_PASSWORD "PASWORD2"

#define  WIFI_SSID_2 "SSID2"
#define  WIFI_PASSWORD_2 "PASSWORD2"

#define  API_KEY "KEY"
#define  USER_EMAIL "E-MAIL ADDR"
#define  USER_PASSWORD "PASSWORD"
#define  DATABASE_URL "https://.....database.app/"

// Instantiate Relay Timer
Relay_TimerClass Relay_Timer = Relay_TimerClass("Start");
// Instantiate Clock Class
Clock_Class Clock= Clock_Class("Start");
RTC_DS3231 rtc;

static FirebaseData stream;
static FirebaseData fbdo;
static FirebaseAuth auth;
static FirebaseConfig config;
static String uid;
static String databasePath;
static String tempPath;
static String timeAndDatePath;
static String statusPath;
static String listenerPath;
static String timerPath;
static String timerRespPath;

static int wakeUpCount = 0;
static int LED_Status = LOW;
static int timeout_minute = 0;
static int reconnect_attempts = 0;
static LiquidCrystal_I2C lcd(0x27, 20, 4);

SemaphoreHandle_t EEPROM_Mutex = NULL;
SemaphoreHandle_t PRINT_Mutex = NULL;

//***********************************************
// InitWiFi *************************************
void InitWiFi() {
	int loop = 5; //wait 5 sec for WLAN_2
	WiFi.begin(WIFI_SSID_2, WIFI_PASSWORD_2);
	printText(0, 1, "Connecting to WiFi2");
	printText(0, 2, ".");
	while (WiFi.status() != WL_CONNECTED) {
		lcd.print(".");
		delay(1000);
		loop--;
		if (loop == 0) { break; }
	}
	if (WiFi.status() == WL_CONNECTED) {
		printText(0, 2, WiFi.localIP().toString());
		return;
	}
	// Try to connect WIFI_SSID
	WiFi.begin(WIFI_SSID, WIFI_PASSWORD);
	printText(0, 1, "Connecting to WiFi1");
	printText(0, 2, ".");
	while (WiFi.status() != WL_CONNECTED) {
		lcd.print(".");
		delay(1000);
	}
	printText(0, 2, WiFi.localIP().toString());
}

//**************************************************
//**************************************************
/*void initBME() {
	bool status = bme.begin(0x76);
	if (!status) {
		printText(0,3,"NO BME280 - STOPP");
		while (1);
	}

}*/

//*************************************************
// Print text to LCD ROW  at specified column and row
void printText(int col, int row, String text)
{
    xSemaphoreTake(PRINT_Mutex, portMAX_DELAY);
	lcd.setCursor(0, row);// set the cursor to column 0 and row
	lcd.print("                    "); // clear the line
	lcd.setCursor(col, row);// set the cursor to column and row
	if (text.length() > 20) {
		text = text.substring(0, 20);
	}
	lcd.print(text);
	xSemaphoreGive(PRINT_Mutex);
}

//*************************************************
// Print text to LCD at specified column and row
void printTextOver(int col, int row, String text)
{
	xSemaphoreTake(PRINT_Mutex, portMAX_DELAY);
	lcd.setCursor(0, row);// set the cursor to column 0 and row
	//lcd.print("                    "); // clear the line
	lcd.setCursor(col, row);// set the cursor to column and row
	lcd.print(text);
	xSemaphoreGive(PRINT_Mutex);
}



//*****************************************************
//*****************************************************
void LcdInit() {
	//InitTimerAndCheck();
	lcd.init();                     // LCD driver initialization
	lcd.backlight();                // Turn on the backlight
	lcd.setCursor(0, 0);// set the cursor to column 0, line 0
	lcd.print("   Home Assistant");
	//callMitObj(lcd);
}


//*****************************************************
//*****************************************************
void setup() {
	// put your setup code here, to run once:
  Serial.begin(115200);
  Wire.begin(SDA, SCL);           // attach the IIC pin
  PRINT_Mutex = xSemaphoreCreateMutex();
  LcdInit();                      // initialize the lcd
  pinMode(LED1, OUTPUT); // Relais-Pins werden als Output deklariert
  pinMode(LED2, OUTPUT);
  pinMode(RELAY_1, OUTPUT); 
  pinMode(RELAY_2, OUTPUT);
  pinMode(RELAY_3, OUTPUT);
  pinMode(RELAY_4, OUTPUT);
  //initBME();
  digitalWrite(LED1, HIGH); // Alle Ausgänge auf HIGH setzen (LED/Relais aus)
  digitalWrite(LED2, HIGH);
  digitalWrite(RELAY_1, HIGH);
  digitalWrite(RELAY_2, HIGH);
  digitalWrite(RELAY_3, HIGH);
  digitalWrite(RELAY_4, HIGH);
  InitWiFi();
  intTimer();
  if (!rtc.begin()) {
	  Serial.println("Failed to initialize RTC 3231");
	  Serial.println("Restarting...");
	  delay(1000);
	  ESP.restart();
  }
  EEPROM_Mutex = xSemaphoreCreateMutex();
  Relay_Timer.EEPROM_Begin(); // Starte EEPROM für Timer
  Relay_Timer.Read_EEPROM();
  SetNTP();
  while (GetLocalTimeNTP() != true)	 {
	  Serial.println("Waiting for NTP Time");
	  delay(1000);
  }
  Setup_Firebase();
  delay(2000);
  if (GetLocalTimeNTP() ==false)
  {
	  Serial.println("NTP Time not set!");
	  delay(1000);
  }
  Clock.temp = 0;
#ifdef DEBUG
  for (int i = 0; i < 4; i++)
  Serial.println("Timer[]-length: " + String(Relay_Timer.Timers[i].length()));
#endif

}
//*****************************************************
//*****************************************************
// the loop function runs over and over again until power down or reset
void loop() {
	printTextOver(0, 0, String (timeout_minute));
	if (timeout_minute == 6) { // controled by hardware timer interrupt every 60 seconds
		//GetLocalTimeNTP();
		wakeUpCount = 0; // reset wake up counter
		Clock.CopyClocktoCurrent();
		Checkfb_ready(); // check Firebase connection
		Clock.SendStatusToFirebase();
		timeout_minute = 0; // wait for next timer interrupt
		Relay_Timer.CheckTimer(); // check all timers 

		if (WiFi.status() != WL_CONNECTED) {  // check WiFi connection and Reconnect
			reconnect_attempts++;
			printText(0, 1, "Reconnect WiFi = " + String(reconnect_attempts));
			WiFi.disconnect();
			WiFi.reconnect();
		}
	}
}
