// DOM elements
const logoutNavElement = document.querySelector('#logout-link');
const loginNavElement = document.querySelector('#login-link');
const signedOutMessageElement = document.querySelector('#signedOutMessage');
const dashboardElement = document.querySelector("#dashboardSignedIn");
const userDetailsElement = document.querySelector('#user-details');
//const delModalElement = document.querySelector("#deleteModalWindow");

// MANAGE LOGIN/LOGOUT UI
const setupUI = (user) => {
  if (user) {
    //toggle UI elements
    logoutNavElement.style.display = 'block';
    loginNavElement.style.display = 'none';
    signedOutMessageElement.style.display ='none';
    dashboardElement.style.display = 'block';
    userDetailsElement.style.display ='block';
    userDetailsElement.innerHTML = user.email;
    //delModalElement.style.display = 'none';

    // get user UID to get data from database
    var uid = user.uid;
    console.log(uid);
  

    // Database paths (with user UID)
    var dbPathLed = 'UsersData/' + uid.toString() + '/outputs/digital/led';
    var dbPathRelay1 = 'UsersData/' + uid.toString() + '/outputs/digital/relay1';
    var dbPathRelay2 = 'UsersData/' + uid.toString() + '/outputs/digital/relay2';
    var dbPathRelay3 = 'UsersData/' + uid.toString() + '/outputs/digital/relay3';
    var dbPathRelay4= 'UsersData/' + uid.toString() + '/outputs/digital/relay4';
    var dbPathMessage = 'UsersData/' + uid.toString() + '/outputs/message';
    var dbPathTimer1 = 'UsersData/' + uid.toString() + '/outputs/timer/timer1';
    var dbPathTimer2 = 'UsersData/' + uid.toString() + '/outputs/timer/timer2';
    var dbPathTimer3 = 'UsersData/' + uid.toString() + '/outputs/timer/timer3';
    var dbPathTimer4 = 'UsersData/' + uid.toString() + '/outputs/timer/timer4';
  
    //var dbPathSlider2 = 'UsersData/' + uid.toString() + '/outputs/pwm/14';
    var dbPathTemp = 'UsersData/' + uid.toString() + '/inputs/temperature';
    var dbPathTimeAndDate = 'UsersData/' + uid.toString() + '/inputs/timeAndDate';
    var dbPathBattery = 'UsersData/' + uid.toString() + '/inputs/status/batteryPower';
    var dbPathFbReady = 'UsersData/' + uid.toString() + '/inputs/status/fbReady';
    var dbPathTimer1Response = 'UsersData/' + uid.toString() + '/inputs/status/timer1resp';
    var dbPathTimer2Response = 'UsersData/' + uid.toString() + '/inputs/status/timer2resp';
    var dbPathTimer3Response = 'UsersData/' + uid.toString() + '/inputs/status/timer3resp';
    var dbPathTimer4Response = 'UsersData/' + uid.toString() + '/inputs/status/timer4resp';
    
    //var dbPathInput1 = 'UsersData/' + uid.toString() + '/outputs/message';


    //////// Button 1 - GPIO 2 ////////
    var ledState = document.getElementById('ledState');
    var dbled = firebase.database().ref().child(dbPathLed);

    // Button 1 - GPIO 2 - Update state message on web page
    dbled.on('value', snap => {
      if(snap.val()==1) {
        ledState.innerText = "ON";
      }
      else {
        ledState.innerText = "OFF";
      }
    });

    // Button 1 - LED - Update database upon button click
    const ledOn = document.getElementById('ledOn');
    const ledOff = document.getElementById('ledOff');

    ledOn.onclick = () => {
      firebase.database().ref().child(dbPathLed).set(1);
    }
    ledOff.onclick = () => {
      firebase.database().ref().child(dbPathLed).set(0);
    }

    ////////  Button 2 - Relay1 ////////
    var relay1State = document.getElementById('relay1State');
    var dbrelay1 = firebase.database().ref().child(dbPathRelay1);

    // Button 2 - Relay1 - Update state message on web page
    dbrelay1.on('value', snap => {
      if(snap.val()==1) {
        relay1State.innerText = "ON";
      }
      else {
        relay1State.innerText = "OFF";
      }
    });

    // Button 2 - Relay1 - Update database upon button click
    const relay1On = document.getElementById('relay1On');
    const relay1Off = document.getElementById('relay1Off');

    relay1On.onclick = () => {
      firebase.database().ref().child(dbPathRelay1).set(1);
    }
    relay1Off.onclick = () => {
      firebase.database().ref().child(dbPathRelay1).set(0);
    }

       ////////  Button 3 - Relay2 ////////
    var relay2State = document.getElementById('relay2State');
    var dbrelay2 = firebase.database().ref().child(dbPathRelay2);

    // Button 3 - Relay2 - Update state message on web page
    dbrelay2.on('value', snap => {
      if(snap.val()==1) {
        relay2State.innerText = "ON";
      }
      else {
        relay2State.innerText = "OFF";
      }
    });

    // Button 3 - Relay2 - Update database upon button click
    const relay2On = document.getElementById('relay2On');
    const relay2Off = document.getElementById('relay2Off');

    relay2On.onclick = () => {
      firebase.database().ref().child(dbPathRelay2).set(1);
    }
    relay2Off.onclick = () => {
      firebase.database().ref().child(dbPathRelay2).set(0);
    }

       ////////  Button 3 - Relay3 ////////
    var relay3State = document.getElementById('relay3State');
    var dbrelay3 = firebase.database().ref().child(dbPathRelay3);

    // Button 2 - Relay3 - Update state message on web page
    dbrelay3.on('value', snap => {
      if(snap.val()==1) {
        relay3State.innerText = "ON";
      }
      else {
        relay3State.innerText = "OFF";
      }
    });

    // Button 4 - Relay3 - Update database upon button click
    const relay3On = document.getElementById('relay3On');
    const relay3Off = document.getElementById('relay3Off');

    relay3On.onclick = () => {
      firebase.database().ref().child(dbPathRelay3).set(1);
    }
    relay3Off.onclick = () => {
      firebase.database().ref().child(dbPathRelay3).set(0);
    }

       ////////  Button 5 - Relay4 ////////
    var relay4State = document.getElementById('relay4State');
    var dbrelay4 = firebase.database().ref().child(dbPathRelay4);

    // Button 5 - Relay4 - Update state message on web page
    dbrelay4.on('value', snap => {
      if(snap.val()==1) {
        relay4State.innerText = "ON";
      }
      else {
        relay4State.innerText = "OFF";
      }
    });

    // Button 5 - Relay4 - Update database upon button click
    const relay4On = document.getElementById('relay4On');
    const relay4Off = document.getElementById('relay4Off');

    relay4On.onclick = () => {
      firebase.database().ref().child(dbPathRelay4).set(1);
    }
    relay4Off.onclick = () => {
      firebase.database().ref().child(dbPathRelay4).set(0);
    }

    //////// Sensor Readings - Temperature - Update web page with new values from database ////////
    var dbTemp = firebase.database().ref().child(dbPathTemp);
    const temp = document.getElementById('temperature');
    const tempCard = document.getElementById("myTempInCard");

    dbTemp.on('value', snap => {
      // Celsius degrees
      temp.innerText = snap.val().toFixed(2) + " ºC";
      tempCard.innerText = snap.val().toFixed(2) + " ºC";
      // Fahrenheit degrees
      //bmeTemp.innerText = snap.val().toFixed(2) + " ºF";
    });

    //////// Sensor Readings - BatteryPower - Update web page with new values from database ////////
    var dbBattery = firebase.database().ref().child(dbPathBattery);
    const battery = document.getElementById('batteryPower');

    dbBattery.on('value', snap => {
      battery.innerText = snap.val();
    });

    //////// Sensor Readings - Firebase Ready - Update web page with new values from database ////////
    var dbFbReady = firebase.database().ref().child(dbPathFbReady);
    const fbReady = document.getElementById('fbReady');

    dbFbReady.on('value', snap => {
      fbReady.innerText = snap.val() ;
    });
  //////// Sensor Readings - TimeAndDate - Update web page with new values from database ////////
    var dbTimeAndDate = firebase.database().ref().child(dbPathTimeAndDate);
    const timeAndDate = document.getElementById('timeAndDate');

    dbTimeAndDate.on('value', snap => {
      timeAndDate.innerText = snap.val().toString();
    });


    //////// Input 1 - Message ////////
    var dbMessage = firebase.database().ref().child(dbPathMessage);
    const input1 = document.getElementById('input1');
    const input1Text = document.getElementById('input1Text');
    // Input 1 - Update input text on web page
    dbMessage.on('value', snap => {
      input1Text.innerText = snap.val();
    });
    // Input 1 - Update database input 1 value
    input1.onchange = () => {
      firebase.database().ref().child(dbPathMessage).set(input1.value);
    }

//??????????????????????????????????????????????????????????????????????????????

var activeTimer =10; // 0-3 Timer; 10 kein Timer gesetzt
var deleteAnswer = 0;
const timerValue={
    firebaseString: "Unused",
    day: "",
    startHour:0,
    startMin: 0,
    endHour: 0,
    endMin: 0,
    repeat:0,
    relay:1
}
const timers = [];

for(i=0;i<4;i++){
    const tim = Object.create(timerValue);
    timers.push(tim); 
    timers[i].firebaseString = "Unused";
}
//import { dbPathTimer} from './index.js';
//const dbPathTimer1 = require('./index.js');
//import { dbPathTimer1, dbPathTimer2, dbPathTimer3, dbPathTimer4 } './index.js';
//import {dbPathTimer1Response, dbPathTimer2Response, dbPathTimer3Response, dbPathTimer4Response } from './index.js';
const msgLine = document.getElementById("msgLine");
const btnt1 = document.getElementById("btnTimer1");
const btnt2 = document.getElementById("btnTimer2");
const btnt3 = document.getElementById("btnTimer3");
const btnt4 = document.getElementById("btnTimer4");
const tbRelay1 = document.getElementById("tblRelay1");
const tbRelay2 = document.getElementById("tblRelay2");
const tbRelay3 = document.getElementById("tblRelay3");
const tbRelay4 = document.getElementById("tblRelay4");
const tbRepeat1 = document.getElementById("tblRepeat1");
const tbRepeat2 = document.getElementById("tblRepeat2");
const tbDay1 = document.getElementById("tblDay1");
const tbDay2 = document.getElementById("tblDay2");
const tbDay3 = document.getElementById("tblDay3");
const tbDay4 = document.getElementById("tblDay4");
const tbDay5 = document.getElementById("tblDay5");
const tbDay6 = document.getElementById("tblDay6");
const tbDay7 = document.getElementById("tblDay7");
const tbDay8 = document.getElementById("tblDay8");
const timerDisplay1 = document.getElementById("lblTimer1");
const timerDisplay2 = document.getElementById("lblTimer2");
const timerDisplay3 = document.getElementById("lblTimer3");
const timerDisplay4 = document.getElementById("lblTimer4");
const inputStartHour = document.getElementById("inputStartHour");
const inputStartMin = document.getElementById("inputStartMin");
const inputEndHour = document.getElementById("inputEndHour");
const inputEndMin = document.getElementById("inputEndMin");
const buttonDelete = document.getElementById("btnDelete");
const btnSend = document.getElementById("btnSend");
const deleteModal =document.getElementById("deleteModalWindow");
const btnDeleteY = document.getElementById("btnDeleteYes");
const btnDeleteN = document.getElementById("btnDeleteNo");
var delModalObj = new bootstrap.Modal(deleteModal,{keyboard:true,backdrop:false});

const msgLineText = "<h5 >Select Timer / Enter Values and Send or Stop Timer</h5>";
const msgTimerText = "day start end repeat relay";
const msgError24H = "<h5 >Wrong input, must be <= 23</h5>";
const msgError59M = "<h5 >Wrong input, must be <= 59</h5>";
const msgErrorNoTimer = "<h5 >No Timer selected</h5>";
const msgHourStart = "<h5 >Enter Hour of Timer Start (0-23)</h5>";
const msgHourEnd = "<h5 >Enter Hour of Timer End (0-23)</h5>";
const msgMinStart = "<h5 >Enter Minutes of Timer Start (0-59)</h5>";
const msgMinEnd = "<h5 >Enter Minutes of Timer End (0-59)</h5>";
const msgErrorTimerUnused = "<h5 >Timer is already Unused</h5>";
const msgErrorTime1 = "<h5 >End (h-start) greater than (h-end)</h5>";
const msgErrorTime2 = "<h5 >End (min-start) greater than (min-end)</h5>";
const msgAckTimerSetting = "<h5 >Timer activated on Device</h5>";
const msgAckTimerSettingError = "<h5 >Timer setting ERROR on Device</h5>";

     //$("btnTimer1").click(function(){btnTimerfunc(1,btnt1);})
    buttonDelete.onclick = function() {btnDeleteFunc()};
    btnSend.onclick = function() {btnSendFunc()};
    //document.getElementById("btnTimer1").addEventListener("click", function() {btnTimerfunc(1);});
    btnt2.onclick =function () {btnTimerfunc(2,btnt2)};
    btnt1.onclick =function () {btnTimerfunc(1,btnt1)};
    btnt3.onclick =function () {btnTimerfunc(3,btnt3)};
    btnt4.onclick =function () {btnTimerfunc(4,btnt4)};
    tbRelay1.onclick= function () {selectRelay(1)};
    tbRelay2.onclick= function () {selectRelay(2)};
    tbRelay3.onclick= function () {selectRelay(3)};
    tbRelay4.onclick= function () {selectRelay(4)};
    tbRepeat1.onclick= function () {selectRepeat(1)};
    tbRepeat2.onclick= function () {selectRepeat(2)};
    tbDay1.onclick= function () {selectDay(1)};
    tbDay2.onclick= function () {selectDay(2)};
    tbDay3.onclick= function () {selectDay(3)};
    tbDay4.onclick= function () {selectDay(4)};
    tbDay5.onclick= function () {selectDay(5)};
    tbDay6.onclick= function () {selectDay(6)};
    tbDay7.onclick= function () {selectDay(7)};
    tbDay8.onclick= function () {selectDay(8)};
    btnDeleteY.onclick = function () {btnDeleteFunc2(1); delModalObj.hide(); this.blur();}
    btnDeleteN.onclick = function () {btnDeleteFunc2(0); delModalObj.hide(); this.blur();}


    inputStartHour.onchange = function () {readStartHour()};
    inputStartHour.onmouseover =function() {msgLine.innerHTML=msgHourStart};
    inputEndHour.onchange = function () {readEndHour()};
    inputEndHour.onmouseover =function() {msgLine.innerHTML=msgHourEnd};
    inputStartMin.onchange = function () {readStartMin()};
    inputStartMin.onmouseover =function() {msgLine.innerHTML=msgMinStart};
    inputEndMin.onchange = function () {readEndMin()};
    inputEndMin.onmouseover =function() {msgLine.innerHTML=msgMinEnd};

    //#####################################################################
    // Device response of Timer Setting
    //#####################################################################
    var dbTimerResponse1 = firebase.database().ref().child(dbPathTimer1Response);
    dbTimerResponse1.on('value', snap => {
    if(snap.val()==1) {
        msgLine.innerHTML = msgAckTimerSetting;
        dbTimerResponse1.set(0);
    }
    });

    var dbTimerResponse2 = firebase.database().ref().child(dbPathTimer2Response);
    dbTimerResponse2.on('value', snap => {
    if(snap.val()==1) {
         msgLine.innerHTML = msgAckTimerSetting;
       dbTimerResponse2.set(0);
     }
    });

    var dbTimerResponse3 = firebase.database().ref().child(dbPathTimer3Response);
    dbTimerResponse2.on('value', snap => {
    if(snap.val()==1) {
         msgLine.innerHTML = msgAckTimerSetting;
       dbTimerResponse3.set(0);
     }
    });

    var dbTimerResponse4 = firebase.database().ref().child(dbPathTimer4Response);
    dbTimerResponse2.on('value', snap => {
    if(snap.val()==1) {
         msgLine.innerHTML = msgAckTimerSetting;
       dbTimerResponse4.set(0);
     }
    });

    //#####################################################################
    // Timer Setting cleared by Device
    //#####################################################################
    var dbTimer1 = firebase.database().ref().child(dbPathTimer1);
    dbTimer1.on('value', snap => {
    if(snap.val() == "Unused") {
        console.log("Timer1 OnChange from firebase Unused");
        deleteTimerObject(0);
        timerDisplay1.innerText= "Unused";
    } else{
        console.log("Timer1 OnChange from firebase not Emtpy");
        timers[0].firebaseString = snap.val();
        timerDisplayString =  createTimerDisplayString( timers[0].firebaseString.split(";"),0);
        timerDisplay1.innerText = timerDisplayString;
    }
     });
   
    var dbTimer2 = firebase.database().ref().child(dbPathTimer2);
    dbTimer2.on('value', snap => {
    if(snap.val() == "Unused") {
        console.log("Timer2 OnChange from firebase Unused");
        deleteTimerObject(1);
        timerDisplay2.innerText= "Unused";
    }else{
        console.log("Timer2 OnChange from firebase not Emtpy");
        timers[1].firebaseString = snap.val();
        timerDisplayString =  createTimerDisplayString( timers[1].firebaseString.split(";"),0);
        timerDisplay2.innerText = timerDisplayString;
        }
     });
    
    var dbTimer3 = firebase.database().ref().child(dbPathTimer3);
    dbTimer3.on('value', snap => {
    if(snap.val() == "Unused") {
        console.log("Timer3 OnChange from firebase Unused");
        deleteTimerObject(2);
        timerDisplay3.innerText= "Unused";
    }else{
        console.log("Timer3 OnChange from firebase not Emtpy");
        timers[2].firebaseString = snap.val();
        timerDisplayString =  createTimerDisplayString( timers[2].firebaseString.split(";"),0);
        timerDisplay3.innerText = timerDisplayString;
        }
     });
     
    var dbTimer4 = firebase.database().ref().child(dbPathTimer4);
    dbTimer4.on('value', snap => {
    if(snap.val() == "Unused") {
        console.log("Timer4 OnChange from firebase Unused");
        deleteTimerObject(3);
        timerDisplay4.innerText= "Unused";
    }else{
        console.log("Timer4 OnChange from firebase not Emtpy");
        timers[3].firebaseString = snap.val();
        timerDisplayString =  createTimerDisplayString( timers[3].firebaseString.split(";"),0);
        timerDisplay4.innerText = timerDisplayString;
        }
     });
    
    
    //#####################################################################
    // Relay Dropdown Button
    //#####################################################################
    const relayDropdown = document.getElementById("relayButton")
        relayDropdown.addEventListener('hidden.bs.dropdown', event =>{
             console.log("Relay Dropdown deactivated");
        })

    function selectRelay(value){
         console.log("Relay selected ==  " + value);
        if (activeTimer >3){
            msgLine.innerHTML= msgErrorNoTimer;
            return;
        }
       if(value==1){
            console.log("Relay 1 pressed");
            timers[activeTimer].relay="1";
        } else if(value==2){
            console.log("Relay 2 pressed");
            timers[activeTimer].relay="2";
        }else if(value==3){
            console.log("Relay 3 pressed");
            timers[activeTimer].relay="3";
         }else if(value==4){
            console.log("Relay 4 pressed");
            timers[activeTimer].relay="4";
         }      
        displayTimer(activeTimer);
    }

    //#####################################################################
    // Repeat Dropdown Button
    //#####################################################################
    const repeatDropdown = document.getElementById("repeatButton")
        repeatDropdown.addEventListener('hidden.bs.dropdown', event =>{
             console.log("Repeat Dropdown deactivated");
        })

    function selectRepeat(value){
         console.log("Repeat selected ==  " + value);
        if (activeTimer >3){
            msgLine.innerHTML= msgErrorNoTimer;
            return;
        }
       if(value==1){
            console.log("Repeat 1 pressed");
            timers[activeTimer].repeat="1";
        } else if(value==2){
            console.log("Repeat 2 pressed");
            timers[activeTimer].repeat="0";
        }
        displayTimer(activeTimer);
    }

    //#####################################################################
    // Day Dropdown Button
    //#####################################################################
    const dayDropdown = document.getElementById("dayButton")
        dayDropdown.addEventListener('hidden.bs.dropdown', event =>{
             console.log("Day Dropdown deactivated");
        })

    function selectDay(value){
         console.log("Day selected ==  " + value);
        if (activeTimer >3){
            msgLine.innerHTML= msgErrorNoTimer;
            return;
        }
       if(value==1){
            console.log("Day 1 pressed");
            timers[activeTimer].day="Mon";
        } else if(value==2){
            console.log("Day 2 pressed");
            timers[activeTimer].day="Tue";
        } else if(value==3){
            console.log("Day 3 pressed");
            timers[activeTimer].day="Wed";
        } else if(value==4){
            console.log("Day 4 pressed");
            timers[activeTimer].day="Thu";
        } else if(value==5){
            console.log("Day 5 pressed");
            timers[activeTimer].day="Fri";
        } else if(value==6){
            console.log("Day 6 pressed");
            timers[activeTimer].day="Sat";
        } else if(value==7){
            console.log("Day 7 pressed");
            timers[activeTimer].day="Sun";
        } else if(value==8){
            console.log("Day 8 pressed");
            timers[activeTimer].day="Mon-Sun";
        }
        displayTimer(activeTimer);
    }
    
    //#####################################################################
    // Function for Timer1 -Timer4 Button
    //#####################################################################
    function btnTimerfunc(timerNum,btn){ 
        console.log( "Function: btnTimerfunc()");
        activeTimer =timerNum-1;
        let timerDisplayString = "";
        for(i=1; i <5; i++){
            let textArray = getTimerFromFirebase(i)
            console.log( "Function: btnTimerfunc() == "+ textArray);
            let timerDisplayString = createTimerDisplayString(textArray, i-1);
            console.log( "Function: btnTimerfunc() == "+ timerDisplayString);
            if(i==1){
                console.log("btnTimer1 pressed");
                timerDisplay1.innerText = timerDisplayString;
            } else if (i==2) {
                console.log("btnTimer2 pressed");
                timerDisplay2.innerText = timerDisplayString;
            }else if (i==3) {
                console.log("btnTimer3 pressed");
                timerDisplay3.innerText = timerDisplayString;
            } else if (i==4) {
                console.log("btnTimer4 pressed");
                timerDisplay4.innerText = timerDisplayString;
            } else{
                console.log("ERROR no btnTimer pressed");
            }      
        }
        deleteAllButtons();
        //deleteAllTimes();
        btn.style.color='blue';
        msgLine.innerHTML= msgLineText;
    }

    //#####################################################################
    // Delete Button
    //#####################################################################
    function btnDeleteFunc(){
        console.log( "Function: btn Delete()");
        if (activeTimer >3){
              msgLine.innerHTML= msgErrorNoTimer;
              return;
        }
        deleteTimerObject(activeTimer);
        inputStartHour.value="";
        inputEndHour.value="";
        inputStartMin.value="";
        inputEndMin.value="";
        // Check if only internal
        /*if(timers[activeTimer].firebaseString == "Unused"){
          msgLine.innerHTML= msgErrorTimerUnused;
            switch(activeTimer){
              case 0:
                timerDisplay1.innerText = "Unused";
                break;
              case 1:
                timerDisplay2.innerText = "Unused";
                break;
              case 2:
                timerDisplay3.innerText = "Unused";
                break;
              case 3:
                timerDisplay4.innerText = "Unused";
                break;
            }

            return;
        } */ 
        // Timer is also external
        delModalObj.show(deleteModal);
        //delModalElement.style.display="block";
      }    
        
    //#####################################################################
    // Delete Button part2 after modal closed
    //#####################################################################
    function btnDeleteFunc2(answer){
        if(answer == 0) return;
        deleteAllButtons();
        if(activeTimer==0){
            console.log("Timer1 deleted");
            timerDisplay1.innerText = "Unused";
            firebase.database().ref().child(dbPathTimer1).set("Unused");
        } else if (activeTimer==1) {
            console.log("Timer2 deleted");
            timerDisplay2.innerText = "Unused";
            firebase.database().ref().child(dbPathTimer2).set("Unused");
        }else if (activeTimer==2) {
            console.log("Timer3 deleted");
            timerDisplay3.innerText = "Unused";
            firebase.database().ref().child(dbPathTimer3).set("Unused");
         } else if (activeTimer==3) {
            console.log("Timer4 deleted");
            timerDisplay4.innerText = "Unused";
            firebase.database().ref().child(dbPathTimer4).set("Unused");
         }      
    }

    //#####################################################################
    // Send Button
    //#####################################################################
    function btnSendFunc(){
        console.log( "Function: btn Send()");
        if (activeTimer >3){
            msgLine.innerHTML= msgErrorNoTimer;
        return;
        }
        if(timers[activeTimer].startHour > timers[activeTimer].endHour){
            msgLine.innerHTML= msgErrorTime1;
            return;
        }
        if((timers[activeTimer].startHour == timers[activeTimer].endHour)
            &&(timers[activeTimer].startMin >= timers[activeTimer].endMin)){
            msgLine.innerHTML= msgErrorTime2;
            return;
        }
        console.log( "Send active Timer to Firebase");
        //setTimeout(checkFirebase, 3000);

        if(activeTimer==0){
            firebase.database().ref().child(dbPathTimer1).set(formatTimerstring(activeTimer));
        } else if (activeTimer==1) {
            firebase.database().ref().child(dbPathTimer2).set(formatTimerstring(activeTimer));
        }else if (activeTimer==2) {
            firebase.database().ref().child(dbPathTimer3).set(formatTimerstring(activeTimer));
        } else if (activeTimer==3) {
            firebase.database().ref().child(dbPathTimer4).set(formatTimerstring(activeTimer));
        }
    } 

    //#####################################################################
    // Start Hour onchange with OK
    //#####################################################################
    function readStartHour(){
          console.log( "Function: readStartHour()");
       if (activeTimer >3){
            msgLine.innerHTML= msgErrorNoTimer;
            inputStartHour.value="";
            return;
        }
        var value = Number(inputStartHour.value);
        //timerDisplay1.innerText = value;
        if (value > 23 || isNaN( value)){
            msgLine.innerHTML= msgError24H;
            inputStartHour.value="0";
        } else {timers[activeTimer].startHour=value.toString();
            msgLine.innerHTML= msgLineText;
            displayTimer(activeTimer);
         }
        console.log("inputStartHour pressed");
    }
 
    //#####################################################################
    // End Hour onchange with OK
    //#####################################################################
    function readEndHour(){
         console.log( "Function: readEndHour()");
       if (activeTimer >3){
            msgLine.innerHTML= msgErrorNoTimer;
            inputEndHour.value="0";
            return;
        }
        var value = Number(inputEndHour.value);
        //timerDisplay1.innerText = value;
        if (value > 23 || isNaN( value)){
            msgLine.innerHTML= msgError24H;
            inputEndHour.value="0";
        } else {timers[activeTimer].endHour=value.toString();
            msgLine.innerHTML= msgLineText;
            displayTimer(activeTimer);
         }
        console.log("inputStartHour pressed");
    }

    //#####################################################################
    // Start Min onchange with OK
    //#####################################################################
    function readStartMin(){
        console.log( "Function: readStartMin()");
        if (activeTimer >3){
            msgLine.innerHTML= msgErrorNoTimer;
            inputStartMin.value="0";
            return;
        }
        var value = Number(inputStartMin.value);
        //timerDisplay1.innerText = value;
        if (value > 59 || isNaN( value)){
            msgLine.innerHTML= msgError59M;
            inputStartMin.value="0";
        } else {timers[activeTimer].startMin=value.toString();
            msgLine.innerHTML= msgLineText;
            displayTimer(activeTimer);
         }
        console.log("inputStartMinute pressed");
    }
 
    //#####################################################################
    // End Min onchange with OK
    //#####################################################################
    function readEndMin(){
         console.log( "Function: readEndMin()");
        if (activeTimer >3){
            msgLine.innerHTML= msgErrorNoTimer;
            inputEndMin.value="0";
            return;
        }
        var value = Number(inputEndMin.value);
        //timerDisplay1.innerText = value;
        if (value > 59 || isNaN( value)){
            msgLine.innerHTML= msgError59M;
            inputEndMin.value="0";
        } else {timers[activeTimer].endMin=value.toString();
            msgLine.innerHTML= msgLineText;
            displayTimer(activeTimer);
         }
        console.log("inputEndMinute pressed");
    }

    //#####################################################################
    // Helper function Delete/Init one Timer object
    //#####################################################################
    function deleteTimerObject(timer){
        console.log( "Function: deleteTimerObject()");
        timers[timer].firebaseString = "Unused";    
        timers[timer].day = "Mon";
        timers[timer].startHour = 0;
        timers[timer].startMin = 0;
        timers[timer].endHour = 0;
        timers[timer].endMin = 0;
        timers[timer].repeat = 0;
        timers[timer].relay = 1;
    }

    //#####################################################################
    // Helper function Delete/Init all Timer buttons
    //#####################################################################
    function deleteAllButtons(){
        console.log( "Function: deleteAllButtons()");
        btnt1.style.color='white';
        btnt2.style.color='white';
        btnt3.style.color='white';
        btnt4.style.color='white';
        inputStartHour.value="";
        inputEndHour.value="";
        inputStartMin.value="";
        inputEndMin.value="";

    }

    //#####################################################################
    // Helper function Get one Timer object from Firebase
    //#####################################################################
    function getTimerFromFirebase(timerNumber){
       console.log( "Function: getTimerFromFirebase()");
       
        let txt = "";    
          if(timerNumber==1){
                var dbPathTim1 = firebase.database().ref().child(dbPathTimer1);
                dbPathTim1.once('value').then((snapshot)=>{
                txt = snapshot.val();
            });    
            dbPathTim1.once('value', (data) => {
                txt= data.val();
                });       
                //read firebase timer 1 here
                //txt = "Do;8:23;12:9;1;1"
            } else if(timerNumber ==2){
                var dbPathTim2 = firebase.database().ref().child(dbPathTimer2);
                dbPathTim2.once('value', (data) => {
                txt= data.val();
                });       
                //read firebase timer 2 here
                //txt = "Di;12:23;12:14;0;2"
            }else if(timerNumber==3){
                var dbPathTim3 = firebase.database().ref().child(dbPathTimer3);
                dbPathTim3.once('value', (data) => {
                txt= data.val();
                });       
                //read firebase timer 3 here
                //txt = "Unused"
                }else if(timerNumber==4){
                var dbPathTim4 = firebase.database().ref().child(dbPathTimer4);
                dbPathTim4.once('value', (data) => {
                txt= data.val();
                });       
                //read firebase timer 4 here
                //txt = "Unused"
          }
            console.log("Function: getTimerFromFirebase() --> " + txt)
            timers[timerNumber-1].firebaseString = txt;
        
        return txt.split(";");  //Return text array of selected timer
    }

    //#####################################################################
    // Helper function Create Display of one Timer object
    //#####################################################################
    function createTimerDisplayString(textArray,timer){
        console.log( "Function: createTimerDisplayString()");
        if(textArray[0] == "Unused") return "Unused";
        else if(textArray.length ==5){
            let text= ""; let txt=""; let help=0;
            text =timers[timer].day = textArray[0];
            text =text + " <";
            help = textArray[1].split(":");
            txt= timers[timer].startHour = help[0];
            text = text+txt + ":";
            txt =timers[timer].startMin = help[1];
            text  = text + txt +"> <";
            help = textArray[2].split(":");
            txt=timers[timer].endHour = help[0];
            text=text + txt + ":";
            txt= timers[timer].endMin = help[1];
            text = text + txt + "> Rep(";
            txt = timers[timer].repeat = textArray[3];
            text = text + txt + ") Relay(";
            txt = timers[timer].relay = textArray[4];
            text = text + txt +")";
            return text;
        }else {console.log( "Timer != 7 elementes"); return "Function: CTDS() PARSE ERROR";}
        return text;
    }

    //#####################################################################
    // Helper function Display one Timer object on screen
    //#####################################################################
    function displayTimer(timer){
        console.log( "Function: displayTimer()");
        let text= ""; let txt="";
        text =timers[timer].day;
        text =text + " <";
        txt= timers[timer].startHour;
        text = text+txt + ":";
        txt =timers[timer].startMin;
        text  = text + txt +"> <";
        txt=timers[timer].endHour;
        text=text + txt + ":";
        txt= timers[timer].endMin;
        text = text + txt + "> Rep(";
        txt = timers[timer].repeat;
        text = text + txt + ") Relay(";
        txt = timers[timer].relay;
        text = text + txt +")";

        if(timer==0){
             timerDisplay1.innerText = text;
        } else if (timer==1) {
            timerDisplay2.innerText = text;
        }else if (timer==2) {
            timerDisplay3.innerText = text;
        } else if (timer==3) {
            timerDisplay4.innerText = text;
        }      
    }

   //#####################################################################
    // Helper function Format timer for device
    //#####################################################################
    function formatTimerstring(timer){
        let text= ""; let txt="";
        text =timers[timer].day;
        text =text + ";";
        txt= timers[timer].startHour;
        text = text+txt + ":";
        txt =timers[timer].startMin;
        text  = text + txt +";";
        txt=timers[timer].endHour;
        text=text + txt + ":";
        txt= timers[timer].endMin;
        text = text + txt + ";";
        txt = timers[timer].repeat;
        text = text + txt + ";";
        txt = timers[timer].relay;
        text = text + txt;
        return text;
    }

    //#####################################################################
    // Helper function Wait for device response
    //#####################################################################
    function checkFirebase(){
        // Read fire base acknowlegde for Timer setting
        let error = msgAckTimerSettingError;   
        msgLine.innerHTML= msgAckTimerSetting;
    }

    //#####################################################################
    // Helper function create the Timers objects
    //#####################################################################
    function initPage(){
       console.log( "Function: initPage()");
        activeTimer=10;
        for(i=0;i<4;i++){
            const tim = Object.create(timerValue);
            timers.push(tim); 
            timers[i].firebaseString = "Unused";

        }
        console.log("OnLoad passed");

    }   

 


  //??????????????????????????????????????????????????????????????????????????????



  // if user is logged out
  } else{
    // toggle UI elements
    logoutNavElement.style.display = 'none';
    loginNavElement.style.display = 'block';
    signedOutMessageElement.style.display ='block';
    dashboardElement.style.display = 'none';
    userDetailsElement.style.display ='none';
  }
}
